//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Representar un triangulo con su notación
// Fecha:    J.29.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,1), C=(1,2);

// El triangulo
draw(A -- B -- C -- cycle);

// Los vértices
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);

// Los lados
label("a", (B+C)/2, N);
label("b", (A+C)/2, NW);
label("c", (A+B)/2, S);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng), radius=3mm, B, A, C, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=5mm, C, B, A, FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng), radius=3mm, A, C, B, FormArc);

