//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Representar el enunciado 1
// Fecha:    J.29.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,1), C=(1,2);

// El triangulo
draw(A -- B -- C -- cycle);

// Los ángulos
pen FormArc=0.5bp+blue;
markangle("$\alpha$", radius=6mm, B, A, C, FormArc);
markangle("$24^\circ$", radius=6mm, C, B, A, FormArc);
markangle("$95^\circ$", radius=6mm, A, C, B, FormArc);

