//---------------------------------------------------------------
// Fichero:  fuera.asy
// Objetivo: Representar una altura que cae fuera del lado opuesto
// Fecha:    S.1.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(-1,2), B=(0,0), C=(3,0);

// El punto proyección
pair Q=(-1,0);

// Marcamos el ángulo recto
markrightangle(C, Q, A, 4mm, gray);

// La recta que contiene la altura
pen Punteado = linetype(new real[] {2,2});
draw((-1,-0.5) -- (-1,2.5), Punteado);
label("$r$", (-1,2.5), SE);

// La altura
draw(A -- Q, 2bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// La continuación del lado
draw(B -- (-1.3,0), Punteado);

// Los puntos
dot("A", A, NW, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, E, 3bp+black);
dot("Q", Q, SW, 3bp+black);
