//---------------------------------------------------------------
// Fichero:  circunferencia.asy
// Objetivo: Representar las circunferencia circunscrita
// Fecha:    M.4.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,1), C=(4,4);

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Dos mediatrices
pair U1=MAB+0.5*Perpendicular(A,B);
pair U2=MAB-0.1*Perpendicular(A,B);
pair V1=MAC+0.2*Perpendicular(A,C);
pair V2=MAC-0.4*Perpendicular(A,C);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);

// Los segmentos del circuncentro a los vértices
draw(T -- A, 0.75bp+deepred);
draw(T -- B, 0.75bp+deepred);
draw(T -- C, 0.75bp+deepred);

// La circunferencia
draw(circle(T,length(T-A)), deepred);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("T", T, NW, 3bp+deepred);
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
