//---------------------------------------------------------------
// Fichero:  propiedad.asy
// Objetivo: Representar la propiedad del incentro
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,1), C=(4,4);

// Los puntos
dot("A", A, NW, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, NW, 3bp+black);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Las bisectrices
pair VR = Bisectriz(A,B,C);
pair R1 = B + 2.5*VR;
pair R2 = B - 0.2*VR;
draw(R1 -- R2, blue);
label("$r$", R1, W, blue);
pair VS = Bisectriz(B,A,C);
pair S1 = A + 2.5*VS;
pair S2 = A - 0.2*VS;
draw(S1 -- S2, blue);
label("$s$", (S1+S2)/2, SE, blue);
pair VT = Bisectriz(B,C,A);
pair T1 = C + 2.5*VT;
pair T2 = C - 0.2*VT;
draw(T1 -- T2, blue);
label("$t$", T1, E, blue);

// El incentro
pair I=intersectionpoint(R1 -- R2, S1 -- S2);
dot(Label("I", fontsize(8pt)+deepred), I, 3*W, 3bp+deepred);

// Los segmentos del incentro a los lados
pair R3=I+Perpendicular(A,C);
pair R4=intersectionpoint(A -- C, I -- R3);
pair S3=I-Perpendicular(B,C);
pair S4=intersectionpoint(B -- C, I -- S3);
pair T3=I-Perpendicular(A,B);
pair T4=intersectionpoint(A -- B, I -- T3);
draw(I -- R4, 0.75bp+deepred);
draw(I -- S4, 0.75bp+deepred);
draw(I -- T4, 0.75bp+deepred);

// Marcamos los ángulos rectos
markrightangle(I, S4, B, 2mm, gray);
markrightangle(I, R4, C, 2mm, gray);
markrightangle(I, T4, B, 2mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);
