//---------------------------------------------------------------
// Fichero:  incentro.asy
// Objetivo: Representar el incentro
// Fecha:    X.26.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(2,5);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// Las bisectrices
pair VR = Bisectriz(A,B,C);
pair R1 = B + 2.8*VR;
pair R2 = B - 0.2*VR;
draw(R1 -- R2, 1bp+blue);
pair VS = Bisectriz(B,A,C);
pair S1 = A + 2.5*VS;
pair S2 = A - 0.2*VS;
draw(S1 -- S2, 1bp+blue);
pair VT = Bisectriz(B,C,A);
pair T1 = C + 2.5*VT;
pair T2 = C - 0.2*VT;
draw(T1 -- T2, 1bp+blue);

// El incentro
pair I=intersectionpoint(R1 -- R2, S1 -- S2);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(I, 4bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);
