//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Mostrar un enunciado
// Fecha:    S.8.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Hipotenusa
real Hip=7;

// Proyección del cateto izquierdo
real Pro=2;

// Altura
real Alt=sqrt(Pro*(Hip-Pro));

// Definición de los vértices
pair A=(0,0), B=(Hip,0), C=(Pro,Alt);

// El ángulo
markrightangle(A, C, B, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$x$", (B+C)/2, N);
label("7", (A+B)/2, S);
label("3", (A+C)/2, W);
