//---------------------------------------------------------------
// Fichero:  obtusangulo2.asy
// Objetivo: Paso 2 del triángulo obtusángulo
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(shift(-2,0)*grid(8,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(-2,3), D=(4,3);

// Los puntos proyección
pair Q=(-2,0), R=(4,0);

// La diagonal
draw(C -- B);

// Los triangulos
draw(A -- B -- C -- cycle);
draw(D -- B -- C -- cycle);

// Las líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q -- A, Punteado+blue);
draw(D -- R, Punteado+blue);

// Los puntos
dot("A", A, S, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, N, 3bp+black);
dot("Q", Q, S, 3bp+black);
dot("R", R, S, 3bp+black);

// La flecha
fill(circle((4.5,1.5),0.1bp), deepgreen);
draw((4.5,1.5) -- (-1.5,1.5), deepgreen, Arrow(5bp));
