//---------------------------------------------------------------
// Fichero:  obtusangulo3.asy
// Objetivo: Paso 3 del triángulo obtusángulo
// Fecha:    J.13.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(shift(-2,0)*grid(6,3,1bp+gray));

// Definición de los vértices
pair C=(-2,3), D=(4,3);

// Los puntos proyección
pair Q=(-2,0), R=(4,0);

// El rectángulo
draw(C -- Q -- R -- D -- cycle);

// Los puntos
dot("C", C, W, 3bp+black);
dot("D", D, E, 3bp+black);
dot("Q", Q, W, 3bp+black);
dot("R", R, E, 3bp+black);
