//---------------------------------------------------------------
// Fichero:  ejercicio.asy
// Objetivo: Ilustrar un ejercicio
// Fecha:    D.6.2.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia a partir de un ángulo
pair PunCir(real Ang)
    { return (Cos(Ang),Sin(Ang)); }

// El centro de la circunferencia
pair T=(0,0);
dot(T, 3bp+black);

// Vértice y extremos
pair V=PunCir(290), A=PunCir(-15), B=PunCir(50);

// Los ángulos
markangle("$\alpha$", radius=4mm, A, T, B, blue);
markangle("$\beta$", radius=4mm, A, V, B, blue);

// La circunferencia
draw(circle(T,1));

// Los ángulos
draw(A -- V -- B);
draw(A -- T -- B);
