#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  esg.py
# Objetivo: Resolver una ecuación de segundo grado
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.9.2.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt()
import math

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Calcula el máximo común divisor de dos números
def mcd(a, b):
    while b: a, b = b, a % b
    return a

#------------------------------------------------
# Imprime una solución
def ImprimeSolucion(Racional, Numerador, Denominador):
    # Imprimimos el valor decimal de la solución
    print u'Solución:', Numerador/Denominador,

    # Si la solución es racional, la simplificamos
    if Racional:
        n=int(Numerador)
        d=int(Denominador)
        m=mcd(n,d)
        n=n/m
        d=d/m
        print '=',n,'/',d
    else:
        print

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
A = sys.argv[1]
B = sys.argv[2]
C = sys.argv[3]

# Convertimos a números los datos leídos
a=float(A)
b=float(B)
c=float(C)

# Añadimos el signo + si es necesario
if b>0: B='+'+B
if c>0: C='+'+C

# Calculamos el discriminante
d=b*b-4*a*c

# Vemos cuántas soluciones tiene la ecuación
s=0; Mensaje = u'no tiene solución'
if d>0:
    s=2; Mensaje = 'tiene dos soluciones'
elif d==0:
    s=1; Mensaje = u'tiene una solución'

# Escribimos la ecuación y cuántas soluciones tiene
print u'La ecuación '+A+u'x²'+B+'x'+C+'=0 '+Mensaje

# Si hay soluciones, las calculamos
if s>0:
    # La raíz del discriminante
    r=math.sqrt(d)

    # Si la raíz es exacta, las soluciones son racionales
    SolRac = True if r*r==d else False

    # Una solución
    ImprimeSolucion(SolRac,-b+r,2*a)

    # Otra solución
    if s==2:
        ImprimeSolucion(SolRac,-b-r,2*a)
