#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  encadenamiento.py
# Objetivo: Calcula el resultado final de un encadenamiento
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    V.17.12.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Devuelve el índice de variación de un porcentaje
def Indice(Porcentaje):
    Respuesta = 0

    if Porcentaje[0] == '+':
        Respuesta = 1+float(Porcentaje[1:])/100

    elif Porcentaje[0] == '-':
        Respuesta = 1-float(Porcentaje[1:])/100

    else:
        print 'Error'

    return Respuesta

#------------------------------------------------
# Devuelve el producto de los números de una lista
def Producto(Lista):
    Respuesta = 1

    for Num in Lista:
        Respuesta *= Num

    return Respuesta

#------------------------------------------------
# Interpreta un índice de variación como porcentaje
def Interpreta(Indice):
    Respuesta = '0'

    if Indice > 1:
        Respuesta = '+' + str(100*(Indice-1))

    if Indice < 1:
        Respuesta = '-' + str(100*(1-Indice))

    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los pasos parciales
Pasos = sys.argv[1:]

# Calculamos los índices de variación de cada paso
IV = map(Indice, Pasos)

# El producto de todos los indices
Global = Producto(IV)

# El resultado final
Resultado = Interpreta(Global)
print Resultado

