//---------------------------------------------------------------
// Fichero:  paso3.asy
// Objetivo: Representar el paso 3
// Fecha:    X.6.10.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Número de subdivisiones
int NumSub = 7;

// Desplazamiento para colocar la rejilla
real Desplazamiento = -NumSub/2;

// El mínimo valor de cada lado
int Min = -floor(NumSub/2);

// Rejilla de ayuda
add(shift(Desplazamiento,Desplazamiento)*grid(NumSub,NumSub,0.5bp+heavygray));

// Los puntos que hay que ir uniendo
pair[] Camino = {(0,0), (1,0), (1,1), (-1,1), (-1,-1), (2,-1), (2,2), (-2,2),
                 (-2,-2), (3,-2), (3,3), (-3,3), (-3,-3), (3,-3) };

// El trazo que recorre los puntos
for ( int i=0 ; i<Camino.length-1 ; ++i )
    {
    // Una línea completa
    draw(Camino[i+1] -- Camino[i], 4bp+palecyan);

    // La dirección en la que vamos
    pair Direccion = unit(Camino[i+1] - Camino[i]);

    // Recorremos todos los cambios de cuadrícula
    for ( pair Punto=Camino[i] ; Punto!=Camino[i+1] ; Punto=Punto+Direccion )
        // Una flecha que atraviesa dos cuadritos
        { draw(Punto+0.43*Direccion -- Punto+0.57*Direccion, 0.3pt+red, Arrow); }
    }

// Tipo de letra
pen Tipo=Helvetica(series="b",shape="n");

// El eje horizontal
for ( int i=Min ; i<-Min+1 ; ++i )
    { label(string(i), (i,0), Tipo+fontsize(18pt)); }

// El eje vertical
for ( int i=Min ; i<-Min+1 ; ++i )
    { label(string(i), (0,i), Tipo+fontsize(18pt)); }

// Las fracciones
for ( int i=Min ; i<-Min+1 ; ++i )
    {
    for ( int j=Min ; j<-Min+1 ; ++j )
        {
        if ( i*j != 0 )
            {
            string Texto = '$\\mathbf{\\frac{' + string(j) + '}{' +
                            string(i) + '}}$';
            label(Texto, (i,j), fontsize(16pt));
            }
        }
    }
