//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Representar el enunciado 4
// Fecha:    V.23.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve como cadena el valor en
// grados, minutos y segundos (redondeados) de un ángulo en grados
string GMS(real Ang)
    {
    int Gra = Floor(Ang);
    Ang = 60*(Ang - Gra);
    int Min = Floor(Ang);
    int Seg = round(60*(Ang - Min));
    string Respuesta = string(Gra)+"$^\circ$\,";
    Respuesta += string(Min)+"$^\prime$\,";
    Respuesta += string(Seg)+"$^{\prime\prime}$";
    return Respuesta;
    }

// Función que devuelve como etiqueta el valor de un ángulo
Label Ang(pair P1, pair V, pair P2, int e)
    { return Eti(GMS(degrees(P2-V)-degrees(P1-V)+360*e)); }

// Definición de los vértices
pair A=(0,0), B=(14,-0.6), C=(14.1,8.3), D=(0.9,8.9);

// Los ángulos
markangle("$\alpha$", radius=5mm, C, B, A, 0.5bp+blue);
markangle(Ang(B,A,D,1), radius=5mm, B, A, D, 0.5bp+blue);
markangle(Ang(D,C,B,0), radius=5mm, D, C, B, 0.5bp+blue);
markangle(Ang(A,D,C,0), radius=5mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
