//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Representar el enunciado 1
// Fecha:    L.26.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve como cadena el valor en
// grados, minutos y segundos (redondeados) de un ángulo en grados
string GMS(real Ang)
    {
    int Gra = Floor(Ang);
    Ang = 60*(Ang - Gra);
    int Min = Floor(Ang);
    int Seg = round(60*(Ang - Min));
    string Respuesta = string(Gra)+"$^\circ$\,";
    Respuesta += string(Min)+"$^\prime$\,";
    Respuesta += string(Seg)+"$^{\prime\prime}$";
    return Respuesta;
    }

// Función que devuelve como etiqueta el valor de un ángulo
Label Ang(pair P1, pair V, pair P2, int e)
    { return Eti(GMS(degrees(P2-V)-degrees(P1-V)+360*e)); }

// Definición de los vértices
pair A=(0,0), B=(7,0), C=(16,0), D=(9,4), E=(1,5);

// Los ángulos
markangle("$\alpha$", radius=6mm, D, C, B, 0.5bp+blue);
markangle(Ang(B,A,E,0), radius=4mm, B, A, E, 0.5bp+blue);
markangle(Ang(A,E,D,0), radius=4mm, A, E, D, 0.5bp+blue);
markangle(Ang(B,D,C,0), radius=6mm, B, D, C, 0.5bp+blue);
markangle(Ang(E,D,B,0), radius=4mm, E, D, B, 0.5bp+blue);

// Las figuras
draw(A -- B -- C -- D -- E -- cycle);
draw(B -- D);
