#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  cociente.py
# Objetivo: Da el cociente un valor en sexagesimal entre un número
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.20.7.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los números de la línea de órdenes

# La expresion sexagesimal tiene el formato h.m.s
Sexagesimal = sys.argv[1]
partesSex = Sexagesimal.split('.')

# El divisor
Divisor = int(sys.argv[2])

# Los datos individuales
HorSex = int(partesSex[0])
MinSex = int(partesSex[1])
SegSex = int(partesSex[2])

# Dividimos las horas
Hor, Resto = divmod(HorSex,Divisor)
MinSex += Resto*60

# Dividimos los minutos
Min, Resto = divmod(MinSex,Divisor)
SegSex += Resto*60

# Dividimos los segundos
Seg = float(SegSex) / Divisor

# Imprimimos el resultado
print str(Hor) + ' ' + str(Min) + ' ' + str(Seg)
