//---------------------------------------------------------------
// Fichero:  reloj.asy
// Objetivo: Representar un reloj analógico de 12 horas
// Fecha:    D.25.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return 1.6*(Cos(angulo),Sin(angulo)); }

// La hora que hay que representar
int Hor=1, Min=50, Seg=25;

// Los colores
pen ColHor=heavyred;
pen ColMin=heavyblue;
pen ColSeg=heavygreen;
pen ColFle=magenta;

// Tipo de letra
pen Tipo = Helvetica(series="m",shape="n");

// Las circunferencias
pair T=(0,0);
draw(circle(T,1),mediumgray);
draw(circle(T,1.43));

// Los minutos
for ( int i=0 ; i<60 ; ++i )
    {
    int Ang = 6*i;
    pair Punto = (Cos(Ang),Sin(Ang));
    dot(Punto,2bp+ColMin);
    }

// Las horas
for ( int i=0 ; i<12 ; ++i )
    {
    int Ang = 60-30*i;
    pair Punto = (Cos(Ang),Sin(Ang));
    label(string(i+1), 1.22*Punto, Tipo);
    dot(Punto,3bp+ColHor);
    }

// La manilla de las horas
path ManHor = (0,0) -- (0,0.7);
real AngHor = -30*(Hor+Min/60+Seg/3600);
draw(rotate(AngHor)*ManHor,1.5pt+ColHor,Arrow(HookHead,size=2mm));

// La manilla de los minutos
path ManMin = (0,0) -- (0,0.9);
real AngMin = -6*(Min+Seg/60);
draw(rotate(AngMin)*ManMin,1.5pt+ColMin,Arrow(HookHead,size=2mm));

// La manilla de los segundos
path ManSeg = (0,0) -- (0,0.93);
real AngSeg = -6*Seg;
draw(rotate(AngSeg)*ManSeg,1pt+ColSeg,Arrow(HookHead,size=1mm));

// El tornillo del centro
dot(T,3.5bp+black);

// Las flechas que indican el sentido de giro
for ( int i=0 ; i<6 ; ++i )
    {
    int Ang = 60*i;
    draw(PuntoCir(Ang+20) .. PuntoCir(Ang+10) .. PuntoCir(Ang),
         1bp+ColFle, ArcArrow(SimpleHead,4bp));
    }

