//---------------------------------------------------------------
// Fichero:  octaedro2d.asy
// Objetivo: Representar un desarrollo plano del octaedro
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Un triángulo equilátero
path Tri=polygon(3);

// La longitud del lado del triángulo
real Long=sqrt(3);

// Repetimos el triángulo
draw(Tri);
draw(shift(Long*E)*Tri);
draw(shift(2*Long*E)*Tri);
draw(shift(Long*(Cos(60),Sin(60)))*Tri);
draw(shift((1.5*Long,0.5))*rotate(180)*Tri);
draw(shift((2.5*Long,0.5))*rotate(180)*Tri);
draw(shift((2*Long,-1))*rotate(180)*Tri);
