//---------------------------------------------------------------
// Fichero:  ortoedro2d.asy
// Objetivo: Representar un desarrollo plano del ortoedro
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El lado del cuadrado
int Lado=1;

// El lado pequeño del rectángulo
real LadoPeq=0.6;

// El desarrollo
draw(box((LadoPeq,0),((LadoPeq+Lado,LadoPeq))));
draw(box((LadoPeq,LadoPeq),((LadoPeq+Lado,LadoPeq+Lado))));
draw(box((0,LadoPeq),((LadoPeq,LadoPeq+Lado))));
draw(box((LadoPeq+Lado,LadoPeq),((2*LadoPeq+Lado,LadoPeq+Lado))));
draw(box((2*LadoPeq+Lado,LadoPeq),((2*LadoPeq+2*Lado,LadoPeq+Lado))));
draw(box((2*LadoPeq+Lado,LadoPeq+Lado),((2*LadoPeq+2*Lado,2*LadoPeq+Lado))));
