//---------------------------------------------------------------
// Fichero:  piramide2d.asy
// Objetivo: Representar un desarrollo plano de una pirámide
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El lado y la altura del triángulo
real Lado=1;

// Un triángulo
path Tri=(-Lado/2,-Lado/2)--(Lado/2,-Lado/2)--(0,Lado/2)--cycle;

// Repetimos el triángulo
draw(shift(0,Lado)*Tri);
draw(shift(-Lado,0)*rotate(90)*Tri);
draw(shift(0,-Lado)*rotate(180)*Tri);
draw(shift(Lado,0)*rotate(270)*Tri);
