//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar un desarrollo plano del cubo
// Fecha:    X.16.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El lado del cuadrado
int Lado=1;

// El número de cuadradito
int Num=1;

// Función que dibuja un cuadrado a partir del punto inferior izquierdo
void Cuadrado(pair V)
    {
    draw(V--V+(0,Lado)--V+(Lado,Lado)--V+(Lado,0)--cycle,1.5bp+black);
    draw(V+(0,Lado/2)--V+(Lado,Lado/2),1bp+blue);
    draw(V+(Lado/2,0)--V+(Lado/2,Lado),1bp+blue);
    for (int i=0; i<4; ++i)
        {
        label(string(Num),V+(i%2*Lado/2+Lado/4,0.75*Lado-quotient(i,2)*Lado/2));
        ++Num;
        };
    }

// El desarrollo
Cuadrado((1,2));
Cuadrado((0,1));
Cuadrado((1,1));
Cuadrado((2,1));
Cuadrado((3,1));
Cuadrado((2,0));
