//---------------------------------------------------------------
// Fichero:  modelo.asy
// Objetivo: Ilustra el modelo
// Fecha:    L.21.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(6cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

/////////////////////////////////////////
// https://asy.marris.fr/asymptote/Positions_relatives/index.html
//         #fig_pa01_251211_plan_droite_perpendiculaires
void angledroit(picture pic=currentpicture,
                triple pO, triple pI, triple pJ, real size=.5, pen p=black,
                projection P=currentprojection){
     triple imI=pO+size*unit(pI-pO),
            imJ=pO+size*unit(pJ-pO),
            imK=imI+imJ-pO;
            draw(imI--imK--imJ,p);
}
/////////////////////////////////////////

// Número de vértices de la base
int N=4;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(-30)*polygon(N));

// El vértice superior
triple V=(0,0,2);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.5));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// El centro de la base
triple Centro=(0,0,0);

// El punto medio de una arista de la base
triple M=(point(PoligonoBase,0)+point(PoligonoBase,1))/2;

// El triángulo rectángulo
draw(Centro--V--M--cycle,2bp+red);

// El ángulo recto
angledroit(Centro,V,M,.2,1bp+red);

// Los puntos
dot(Centro,4bp+black);
dot(M,4bp+black);
dot(V,4bp+black);

// Los textos
pen Formato=Helvetica(series="m",shape="n")+fontsize(4mm)+black;
label("h",Centro+0.7*(V-Centro)/2-0.2*X,Formato);
label("m",M+0.6*(V-M)/2+0.3*Z,Formato);
label("q",Centro+0.6*(M-Centro)+0.3*Y,Formato);
triple M=(point(PoligonoBase,2)+point(PoligonoBase,1))/2;
label("d",M+0.2*Y,Formato);
