//---------------------------------------------------------------
// Fichero:  agujero3d.asy
// Objetivo: Mostrar un cuerpo con agujero
// Fecha:    X.30.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(5cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana
real Radio=4, Altura=5;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(1.3*Radio,0,0.5*Altura)--
           (Radio,0,Altura)--(0,0,Altura)--cycle;

// El cuerpo de revolución
draw(surface(revolution(shift(3*X)*Poli,Z)),lightgray);
