//---------------------------------------------------------------
// Fichero:  cilindro3d.asy
// Objetivo: Mostrar un cilindro
// Fecha:    S.2.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.4cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana
real Radio=4, Altura=3;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// El cuerpo de revolución
revolution Cilindro=revolution(Poli,Z);

// Dibujamos
draw(surface(Cilindro),lightgray);
draw(Cilindro.silhouette(),1bp+black);
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+black);
