//---------------------------------------------------------------
// Fichero:  cono2d.asy
// Objetivo: Mostrar cómo crear un cono
// Fecha:    M.5.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Datos de la figura plana
real Radio=4, Altura=5;

// La figura plana
path Poli=(0,0)--(Radio,0)--(0,Altura);
draw(Poli,2bp+black);

// Marcamos el ángulo recto
markrightangle((0,Altura), (0,0), (Radio,0), 4mm, 1bp+blue);

// El eje
real Extra=.4;
draw((0,-Extra)--(0,Altura+Extra), 2bp+black);

// La flecha del giro
path Flecha=(Extra,Altura)..(0,Altura+2*Extra)..(-Extra,Altura);
draw(shift(0,Extra)*Flecha,1bp+blue,ArcArrow(SimpleHead));
