//---------------------------------------------------------------
// Fichero:  radio2d.asy
// Objetivo: Mostrar el radio del círculo
// Fecha:    D.10.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Datos de la figura plana
real Radio=4, Altura=4;

// Definimos dos puntos
pair T=(0,0), A=(Radio,0);

// La figura plana
path Poli=circle((0,0),Radio);
draw(Poli,2bp+black);

// El radio
draw(A--T, 1bp+blue);
label("radio",(A+T)/2,S,blue);

// Los puntos
dot(T,3bp+blue);
dot(A,3bp+blue);
