//---------------------------------------------------------------
// Fichero:  cilindro-esfera-r.asy
// Objetivo: Mostrar la esfera y el cilindro con sus dimensiones
// Fecha:    L.11.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution() sphere()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,0,2),Z);

// Datos de la figura
real Radio=1, Altura=2;

// Los puntos importantes
triple T=(0,0,0), A=(0,Radio,0), B=(0,Radio,Altura);
triple C=(0,-Radio,0), D=(0,-Radio,Altura);
triple V=(0,0,Radio), W=(0,Radio,Radio);

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// El cilindro
revolution Cilindro=revolution(Poli,Z);

// La esfera
revolution Esfera=sphere(V,1);

// Marcamos las bases del cilindro
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+black);
draw(shift(-Altura/2*Z)*Corte.transverse.back,1bp+black+linetype("4 4",8));

// Marcamos el contorno del cilindro
draw(Cilindro.silhouette(),1bp+black);

// Dibujamos la esfera
skeleton Corte;
Esfera.transverse(Corte,reltime(Esfera.g,0.5),P=currentprojection);
draw(Corte.transverse.back,darkgreen+linetype("4 4",8));
draw(Corte.transverse.front,darkgreen);
draw(Esfera.silhouette(),darkgreen);

// El radio de la esfera
draw(V--W,blue);
label("$r$",(V+W)/2,S,blue);

// Los puntos que marcamos
//dot(A,3bp+blue);
//dot(T,3bp+blue);
dot(C,3bp+blue);
dot(D,3bp+blue);
dot(V,3bp+blue);
dot(W,3bp+blue);

// El radio de la base de abajo
// Nota: no lo dibujo porque no sale bien
//draw(A--T,1bp+blue);
//label("$r$",(A+T)/2+0.125*Z,blue);

// La altura
draw(C--D,1bp+blue);
label("$2r$",(C+D)/2-0.125*Y,blue);
