//---------------------------------------------------------------
// Fichero:  b2.asy
// Objetivo: Resolver (b2)
// Fecha:    L.30.1.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.6cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 4, Ymin = -2, Ymax = 3, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-4.5,1.5) -- (-1.5,-1.5));
draw((-0.5,3.5) -- (3.5,-0.5));

// Las flechas que salen desde y=1
draw((-0.5,1) -- (-3.8,1), deepgreen, Arrow(HookHead,3bp));
draw((0.2,1) -- (1.8,1), deepgreen, Arrow(HookHead,3bp));

// Los puntos
dot((-4,1),red+3pt);
dot((2,1),red+3pt);

// Las flechas que van al eje de abscisas
draw((-4,0.8) -- (-4,0.2), deepgreen, Arrow(HookHead,3bp));
draw((2,0.8) -- (2,0.2), deepgreen, Arrow(HookHead,3bp));
