//---------------------------------------------------------------
// Fichero:  funcionG.asy
// Objetivo: Representar la solución de una función
// Fecha:    V.10.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de los ejes
real Xmin = -8, Xmax = 8, Ymin = -1, Ymax = 2, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-8,-1) -- (-2,-1));
draw((-2,1) -- (4,1));
draw((4,2) -- (8,2));

// Los puntos del eje de abscisas
dot((-5.4,0),blue+3pt);
dot((0.8,0),blue+3pt);
dot((6.7,0),blue+3pt);

// Las flechas van a la gráfica
draw((-5.4,-0.1) -- (-5.4,-0.9), deepgreen, Arrow(HookHead,3bp));
draw((0.8,0.1) -- (0.8,0.9), deepgreen, Arrow(HookHead,3bp));
draw((6.7,0.1) -- (6.7,1.9), deepgreen, Arrow(HookHead,3bp));

// Los puntos de la gráfica
dot((-5.4,-1),red+3pt);
dot((0.8,1),red+3pt);
dot((6.7,2),red+3pt);
