//---------------------------------------------------------------
// Fichero:  absolutos.asy
// Objetivo: Representar una función con un máximo y mínimo absolutos
// Fecha:    L.13.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Caracteres Unicode
import unicode;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 8, Ymin = 0, Ymax = 8, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((1,8) .. controls (2,5) and (7,3) .. (8,1));

// Dos puntos de la gráfica
dot((1,8),red+3pt);
dot((8,1),red+3pt);

// Explicaciones
label("Máximo absoluto",(1,8),2*E,fontsize(6pt));
label("Mínimo absoluto",(8,1),2*W,fontsize(6pt));
