//---------------------------------------------------------------
// Fichero:  funcion1.asy
// Objetivo: Representar una función
// Fecha:    V.17.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis(), graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -4, Ymax = 4, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real F1(real x) { return (-0.25*x^2-x); }
real F2(real x) { return (0.75*(x^2-4*x)); }
path Grafica1=graph(F1,-6,0,n=400);
path Grafica2=graph(F2,0,4,n=400);
draw(Grafica1);
draw(Grafica2);
draw((4,0) .. controls (5,1) and (6,2) .. (6,4));

