//---------------------------------------------------------------
// Fichero:  paso2.asy
// Objetivo: Mostrar el paso 2 de la explicación
// Fecha:    L.20.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 7, Ymin = -6, Ymax = 5, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-7,-5.75)--(7,4.75));

// Dos puntos
pair A=(-2,-2), B=(6,4);
dot(A,3pt+red);
dot(B,3pt+red);

// La flecha que sube desde x=2
draw((2,0.3) -- (2,0.7), deepgreen, Arrow(HookHead,1.5bp));

// El punto
dot((2,1),deepgreen+3pt);

// La flecha que va hasta y=1
draw((1.7,1) -- (0.3,1), deepgreen, Arrow(HookHead,1.5bp));
