//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Representar gráficamente dos funciones lineales
// Fecha:    M.4.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 5, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// Las gráficas
draw((0,1) -- (10,5));
draw((0,4) -- (10,2));

// El punto de corte
dot((5,3),4pt+red);

// Los nombres
label("F",(10,5),E,FormatoTexto);
label("G",(10,2),E,FormatoTexto);
