//---------------------------------------------------------------
// Fichero:  sucesion.asy
// Objetivo: Mostrar una sucesión de ángulos
// Fecha:    V.2.9.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Hay que dibujar cuatro polígonos
for (int n=3 ; n<7 ; ++n)
  {
  // El polígono
  path Poligono=shift((n-2)*2.5,0)*polygon(n);

  // Lo dibujamos
  draw(Poligono);

  // El ángulo
  pair V0=point(Poligono,0);
  pair V1=point(Poligono,n-1);
  pair V2=point(Poligono,n-2);
  real Valor=180*(n-2)/n;
  string Texto=string(Valor)+"$^\circ$";
  markangle(Label(Texto,fontsize(10pt)+blue), radius=3mm, V0, V1, V2, 1bp+blue);
  }
