#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  dt.py
# Objetivo: Calcula la desviación típica de un conjunto de datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    D.26.11.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt()
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Datos = sys.argv[1:]

# Los convertimos en números reales
Datos = map(float,Datos);

# Calculamos los cuadrados de los datos
Cuadrados = map(lambda x: x*x,Datos)

# Calculamos la media
Media = sum(Datos)/len(Datos)

# Calculamos la desviación típica
Sigma = math.sqrt((sum(Cuadrados)/len(Datos))-Media**2)

# Damos el resultado
print str(Sigma).replace('.', ',')
