//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Representar el polígono de frecuencias acumuladas
// Fecha:    L.18.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(2);

// Los valores de los extremos de los intervalos
string Valor[]={'38', '42', '46', '50', '54', '58', '62', '66'};
int TotalVal = Valor.length;

// Las frecuencias absolutas acumuladas
int Frecuencia[]={0,115,261,492,595,685,766,820};
int MaxFre=max(Frecuencia);
int TotalFre = Frecuencia.length;

// Escala para modificar los porcentajes
real Escala=0.006;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// Formatos
pen FormatoTexto=blue+fontsize(8pt);
pen FormatoTextoResaltado=deepmagenta+fontsize(8pt);
pen FormatoPunto=red+4bp;

// El eje de ordenadas
for ( int i=0 ; i<TotalFre ; ++i )
    {
    int Valor=Frecuencia[i];
    label(string(Valor), (0,Escala*Valor), 2*W, FormatoTexto);
    draw((-0.05,Escala*Valor)--(0.05,Escala*Valor));
    }
real V=Escala*164;
label('164', (0,V), 2*W, FormatoTextoResaltado);
draw((-0.05,V)--(0.05,V));
real V=Escala*492;
label('492', (0,V), 2*W, FormatoTextoResaltado);
draw((-0.05,V)--(0.05,V));
real V=Escala*656;
label('656', (0,V), 2*W, FormatoTextoResaltado);
draw((-0.05,V)--(0.05,V));

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Los segmentos
for ( int i=1 ; i<TotalVal ; ++i )
    { draw((i,Escala*Frecuencia[i-1])--(i+1,Escala*Frecuencia[i])); }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoTexto);
    draw((i+1,-0.05)--(i+1,0.05));
    }
real X=2.335;
label('$d_2$', (X,0), 1.5*S, FormatoTextoResaltado);
draw((X,-0.05)--(X,0.05));
real X=4;
label('$=d_6$', (X,0), 1.5*S+2.3*E, FormatoTextoResaltado);
draw((X,-0.05)--(X,0.05));
real X=5.6775;
label('$d_8$', (X,0), 1.5*S, FormatoTextoResaltado);
draw((X,-0.05)--(X,0.05));

// Los tres segmentos que nos interesan
draw((2,Escala*Frecuencia[1])--(3,Escala*Frecuencia[2]), heavygreen+2bp);
draw((5,Escala*Frecuencia[4])--(6,Escala*Frecuencia[5]), heavygreen+2bp);

// Los puntos
for ( int i=1 ; i<=TotalVal ; ++i )
    { dot((i,Escala*Frecuencia[i-1]), FormatoPunto); }

// Primer decil
real Sep=0.15;
real V=Escala*164, X=2.335;
dot((X,V),deepmagenta+5bp);
draw((Sep,V) -- (X-Sep,V), magenta+1.5bp, Arrow(HookHead,4bp));
draw((X,V-Sep) -- (X,Sep), magenta+1.5bp, Arrow(HookHead,4bp));

// Segundo decil
real V=Escala*492, X=4;
dot((X,V),deepmagenta+5bp);
draw((Sep,V) -- (X-Sep,V), magenta+1.5bp, Arrow(HookHead,4bp));
draw((X,V-Sep) -- (X,Sep), magenta+1.5bp, Arrow(HookHead,4bp));

// Tercer decil
real V=Escala*656, X=5.6775;
dot((X,V),deepmagenta+5bp);
draw((Sep,V) -- (X-Sep,V), magenta+1.5bp, Arrow(HookHead,4bp));
draw((X,V-Sep) -- (X,Sep), magenta+1.5bp, Arrow(HookHead,4bp));
