//---------------------------------------------------------------
// Fichero:  cruzgriega.asy
// Objetivo: Dibujar una cruz griega
// Fecha:    J.11.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair V[]={(1,0), (2,0), (2,1), (3,1), (3,2), (2,2), (2,3), (1,3), (1,2), (0,2),
          (0,1), (1,1)};

// La construcción
guide Cruz;
for ( int i=0 ; i<V.length ; ++i )
    { Cruz = Cruz -- V[i]; }
Cruz = Cruz -- cycle;
draw(Cruz);
