//---------------------------------------------------------------
// Fichero:  ilustracion.asy
// Objetivo: Mostrar la ilustración del octógono
// Fecha:    M.2.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El octógono
path Octogono=polygon(8);

// El centro
pair C=(point(Octogono,0)+point(Octogono,4))/2;

// Los dos vértices del lado de abajo a la derecha
pair A=point(Octogono,0);
pair B=point(Octogono,1);

// El punto medio del lado de abajo
pair M=(A+point(Octogono,7))/2;

// El punto medio del lado de la derecha
pair N=(B+point(Octogono,2))/2;

// El punto que divide la apotema
pair D=(0,B.y);

// La esquina de la derecha
pair Q=(B.x,A.y);

// La apotema
draw(M--C);

// Las líneas de puntos
pen Punteado = linetype(new real[] {2,2}) + gray;
draw(C--N, Punteado);
draw(D--B, Punteado);
draw(Q--B, Punteado);
draw(Q--A, Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.1;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.75bp;
draw(C+Separacion*(-1,0) -- M+Separacion*(-1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(C+Separacion*(1,0) -- D+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(M+Separacion*(1,0) -- D+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(N+Separacion*(1,0) -- B+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(Q+Separacion*(1,0) -- B+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(A+Separacion*(0,-1) -- Q+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));


// Los textos
pen FormatoTexto=fontsize(10pt)+Helvetica(series="b",shape="n");
label("a", (M+C)/2+Separacion*(-2,0), red+FormatoTexto);
label("3,5", (D+C)/2+Separacion*(2.5,0), deepgreen+FormatoTexto);
label("x", (D+M)/2+Separacion*(2,0), red+FormatoTexto);
label("3,5", (B+N)/2+Separacion*(2.5,0), deepgreen+FormatoTexto);
label("x", (B+Q)/2+Separacion*(2,0), red+FormatoTexto);
label("x", (A+Q)/2+Separacion*(0,-2), red+FormatoTexto);
label("7", (A+B)/2+Separacion*(-0.75,0.75), deepgreen+FormatoTexto);

// Dibujamos el octógono
draw(Octogono);

// Marcamos los puntos importantes
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(M,FormatoPunto);
dot(N,FormatoPunto);
dot(Q,FormatoPunto);
