//---------------------------------------------------------------
// Fichero:  snooker.asy
// Objetivo: Dibujar el problema del snooker
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// La esquina de la mesa de snooker
pair Esquina=30.5*(12,6);

// Los centros de las bolas
pair Blanca=(60,75);
pair Roja=(320,158);

// Las perpendiculares
draw(Blanca -- (Blanca.x,0),0.25+blue);
draw(Roja -- (Roja.x,0),0.25+blue);

// Los ángulos rectos
pen FormatoAngulo = 0.25bp+blue;
markrightangle(Blanca, (Blanca.x,0), (0,0), 1.5mm, FormatoAngulo);
markrightangle(Roja, (Roja.x,0), (Esquina.x,0), 1.5mm, FormatoAngulo);

// Las longitudes de las alturas
pen FormatoTexto = fontsize(6pt)+blue;
label(string(Blanca.y), (Blanca.x,Blanca.y/2), W, FormatoTexto);
label(string(Roja.y), (Roja.x,Roja.y/2), E, FormatoTexto);

// La mesa de snooker
draw(box((0,0),Esquina));

// La distancia horizontal
dot((Blanca.x,0),2bp+blue);
dot((Roja.x,0),2bp+blue);
draw((Blanca.x,-10) -- (Roja.x,-10), 0.5bp+blue);
label(string(Roja.x-Blanca.x), (Esquina.x/2,0), 3S, FormatoTexto);

// La incógnita
real x=83.7;
draw(Blanca -- (Blanca.x+x,0) -- Roja, 0.5bp+heavygreen);
dot((Blanca.x+x,0),2bp+blue);
label("x", (Blanca.x+x/2,0), N, FormatoTexto);

// Las bolas
filldraw(circle(Blanca,5),white,0.5bp+black);
filldraw(circle(Roja,5),red,0.5bp+red);

