//---------------------------------------------------------------
// Fichero:  enunciado8.asy
// Objetivo: Dibujar el enunciado 8
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// El radio de la semicircunferencia
real r=73;

// Un punto de la semicircunferencia y su proyección
pair C=r*dir(67);
pair Q=(C.x,0);

// La altura
draw(C -- Q, blue);

// La semicircunferencia
draw(arc((0,0),r,0,180));

// El diámetro
pair A=(-r,0), B=(r,0);
draw(A -- B);

// La cuerda que pedimos
pen FormatoPunto=4bp+red;
dot(A,FormatoPunto);
dot(C,FormatoPunto);
draw(A -- C, 2bp+red);

// El dato
pen FormatoPunto=3bp+blue;
pen FormatoTexto=blue+fontsize(8pt);
dot(B,FormatoPunto);
dot(Q,FormatoPunto);
label(Dist(B,Q), (B+Q)/2, S, FormatoTexto);

// El ángulo recto
pen FormatoAngulo = 0.5bp+blue;
markrightangle(C, Q, A, 4mm, FormatoAngulo);
