//---------------------------------------------------------------
// Fichero:  enunciado9.asy
// Objetivo: Dibujar el enunciado 9
// Fecha:    S.2.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// El radio de la semicircunferencia
real r=23;

// Dos puntos de la semicircunferencia y sus proyecciones
pair C1=r*dir(115), C2=r*dir(35);
pair Q1=(C1.x,0), Q2=(C2.x,0);

// Las alturas
draw(C1 -- Q1, blue);
draw(C2 -- Q2, blue);

// La semicircunferencia
draw(arc((0,0),r,0,180));

// El diámetro
pair A=(-r,0), B=(r,0);
draw(A -- B);

// La cuerda que pedimos
pen FormatoPunto=4bp+red;
dot(C1,FormatoPunto);
dot(C2,FormatoPunto);
draw(C1 -- C2, 2bp+red);

// Los datos
pen FormatoPunto=3bp+blue;
pen FormatoTexto=blue+fontsize(8pt);
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(Q1,FormatoPunto);
dot(Q2,FormatoPunto);
label(Dist(A,Q1), (A+Q1)/2, S, FormatoTexto);
label(Dist(B,Q2), (B+Q2)/2, S, FormatoTexto);

// Los ángulos rectos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(C1, Q1, B, 3mm, FormatoAngulo);
markrightangle(C2, Q2, A, 3mm, FormatoAngulo);
