//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos cuadriláteros semejantes
// Fecha:    J.15.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Los vértices
pair A1=(0,0), B1=(5,0), C1=(3.5,1.5), D1=(1,2);

// El primer cuadrilátero
path Cuad1 = A1 -- B1 -- C1 -- D1 -- cycle;
draw(Cuad1);

// El segundo cuadrilátero
transform F=shift(8,0)*scale(1.3);
pair A2=F*A1, B2=F*B1, C2=F*C1, D2=F*D1;
path Cuad2 = F*Cuad1;
draw(Cuad2);

// Los nombres de los vértices
label("A",A1,W);
label("A'",A2,W);
label("B",B1,E);
label("B'",B2,E);
label("C",C1,NE);
label("C'",C2,NE);
label("D",D1,N);
label("D'",D2,N);

// Las longitudes de los lados
label("a",Med(A1,B1),S,blue);
label("a'",Med(A2,B2),S,blue);
label("b",Med(C1,B1),NE,blue);
label("b'",Med(C2,B2),NE,blue);
label("c",Med(C1,D1),N,blue);
label("c'",Med(C2,D2),N,blue);
label("d",Med(A1,D1),W,blue);
label("d'",Med(A2,D2),W,blue);

// Los ángulos
markangle("$\alpha$", radius=3mm, B1, A1, D1, 0.5bp+blue);
markangle("$\alpha$'", radius=3mm, B2, A2, D2, 0.5bp+blue);
markangle("$\beta$", radius=4mm, C1, B1, A1, 0.5bp+blue);
markangle("$\beta$'", radius=4mm, C2, B2, A2, 0.5bp+blue);
markangle("$\gamma$", radius=2mm, D1, C1, B1, 0.5bp+blue);
markangle("$\gamma$'", radius=2mm, D2, C2, B2, 0.5bp+blue);
markangle("$\delta$", radius=3mm, A1, D1, C1, 0.5bp+blue);
markangle("$\delta$'", radius=3mm, A2, D2, C2, 0.5bp+blue);
