//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Ilustrar el ejemplo2
// Fecha:    D.16.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Los vértices
pair A=(0,0), B=(5,-3), C=(11,-1), D=(8,3), E=(2,3);

// Los triángulos
draw(A -- C, gray);
draw(A -- D, gray);
draw(A -- E, gray);

// El polígono
draw(A -- B -- C -- D -- E -- cycle);

// Los nombres de los triángulos
label("T1",Bar(A,E,D),blue+fontsize(10pt));
label("T2",Bar(A,C,D),blue+fontsize(10pt));
label("T3",Bar(A,B,C),blue+fontsize(10pt));
