//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    L.17.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Los vértices
pair A1=(0,0), B1=(5,0), C1=(1.5,2);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(8,0)*scale(1.4);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("A",A1,W);
label("A'",A2,W);
label("B",B1,E);
label("B'",B2,E);
label("C",C1,N);
label("C'",C2,N);

// Las longitudes de los lados
label("a",Med(B1,C1),NE,blue);
label("a'",Med(B2,C2),NE,blue);
label("b",Med(A1,C1),NW,blue);
label("b'",Med(A2,C2),NW,blue);
label("c",Med(A1,B1),S,blue);
label("c'",Med(A2,B2),S,blue);

// Los ángulos
markangle("$\alpha$", radius=3mm, B1, A1, C1, 0.5bp+blue);
markangle("$\alpha$'", radius=3mm, B2, A2, C2, 0.5bp+blue);
markangle("$\beta$", radius=8mm, C1, B1, A1, 0.5bp+blue);
markangle("$\beta$'", radius=8mm, C2, B2, A2, 0.5bp+blue);
markangle("$\gamma$", radius=2mm, A1, C1, B1, 0.5bp+blue);
markangle("$\gamma$'", radius=2mm, A2, C2, B2, 0.5bp+blue);
