//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos triángulos rectángulos semejantes
// Fecha:    J.27.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Los vértices
pair A1=(0,0), B1=(3,0), C1=(0,2);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(5,0)*scale(0.8);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("A",A1,SW);
label("D",A2,SW);
label("B",B1,SE);
label("E",B2,SE);
label("C",C1,N);
label("F",C2,N);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markangle(Ang(C1,B1,A1,0), radius=6mm, C1, B1, A1, FormatoAngulo);
markangle(Ang(C2,B2,A2,0), radius=6mm, C2, B2, A2, FormatoAngulo);
markrightangle(B1, A1, C1, 4mm, FormatoAngulo);
markrightangle(B2, A2, C2, 4mm, FormatoAngulo);
