//---------------------------------------------------------------
// Fichero:  lateral2D.asy
// Objetivo: Mostrar en 2D una cara lateral
// Fecha:    X.6.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(-2,0), B=(2,0), C=(1.5,2), D=(-1.5,2);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// La altura
draw((0,0) -- (0,2));

// Los textos
pen FormatoTexto=fontsize(10pt)+blue;
label("$d$", (A+B)/2, S, FormatoTexto);
label("$e$", (C+D)/2, N, FormatoTexto);
label("$t$", (A+D)/2, W, FormatoTexto);
label("$t$", (B+C)/2, E, FormatoTexto);
label("$m$", (0,1), E, FormatoTexto);

// Marcamos los ángulos rectos
markrightangle(A, (0,0), (0,2), 2mm, 0.5bp+blue);
markrightangle(D, (0,2), (0,0), 2mm, 0.5bp+blue);
