//---------------------------------------------------------------
// Fichero:  distintolado.asy
// Objetivo: Mostrar un segmento esférico con bases en distinto lado
// Fecha:    X.27.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La figura plana
real Altura1=0.8, Altura2=-0.7;
real a=sqrt(1-Altura1^2), b=sqrt(1-Altura2^2);
path3 Arco=arc((0,0,0), (a,0,sqrt(1-a^2)), (b,0,-sqrt(1-b^2)), Y);

// El cuerpo de revolución
draw(surface(revolution(Arco,Z)),lightgray+opacity(.5));
draw(circle((0,0,sqrt(1-a^2)),a),1bp+black);
draw(surface(circle((0,0,sqrt(1-a^2)),a)),lightgray);
draw(circle((0,0,-sqrt(1-b^2)),b),1bp+black);
draw(surface(circle((0,0,-sqrt(1-b^2)),b)),lightgray);

// Un plano que corta a la esfera
real Lado=2.25;
real Altura=0;
path3 Plano=shift(-Lado/2,-Lado/2,Altura)*scale3(Lado)*unitsquare3;
draw(rotate(30,Z)*surface(Plano),red+opacity(.3));
draw(rotate(30,Z)*Plano,0.25bp+red);

// El círculo de corte de la esfera y el plano
draw(surface(circle((0,0,Altura),sqrt(1-Altura^2))),lightred+opacity(.2));
draw(circle((0,0,Altura),sqrt(1-Altura^2)),red);

// Punto invisibles
dot(-Z,white);
