//---------------------------------------------------------------
// Fichero:  zona.asy
// Objetivo: Mostrar una zona esférica y su cilindro asociado
// Fecha:    V.29.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La esfera
draw(unitsphere,gray+opacity(.5));

// Dos planos paralelos que cortan a la esfera
real Lado=2.25;
real Altura1=0.8, Altura2=-0.5;
path3 Plano1=shift(-Lado/2,-Lado/2,Altura1)*scale3(Lado)*unitsquare3;
path3 Plano2=shift(-Lado/2,-Lado/2,Altura2)*scale3(Lado)*unitsquare3;
draw(surface(Plano1),red+opacity(.1));
draw(surface(Plano2),red+opacity(.1));
draw(Plano1,0.25bp+red);
draw(Plano2,0.25bp+red);

// Los círculos de corte de la esfera y los planos
draw(circle((0,0,Altura1),sqrt(1-Altura1^2)),red);
draw(circle((0,0,Altura2),sqrt(1-Altura2^2)),red);

// El cilindro
transform3 F=shift(Altura2*Z)*zscale3(Altura1-Altura2);
draw(F*unitcylinder,palegreen+opacity(.5));
draw(circle((0,0,Altura1),1),darkgreen);
draw(circle((0,0,Altura2),1),darkgreen);
