//---------------------------------------------------------------
// Fichero:  cilindro.asy
// Objetivo: Mostrar el cilindro esférico
// Fecha:    D.1.10.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic((4,0,1),Z);

// Datos de la figura plana
// He puesto 1.01 para evitar un error
real Radio=1.01, Altura=1;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// Líneas de puntos
pen Punteado=linetype("2 2",8);

// El cuerpo de revolución
revolution Cilindro=revolution(Poli,Z);

// Marcamos las bases
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+gray);
draw(shift(-Altura/2*Z)*Corte.transverse.back,1bp+gray+Punteado);

// Marcamos el contorno
draw(Cilindro.silhouette(),1bp+gray);

// Para dibujar el cono, añadimos dos líneas
draw((0,Radio,0)--(0,0,Altura)--(0,-Radio,0),1bp+gray);

// Para dibujar la semiesfera, añadimos un arco
draw((0,-Radio,0)..(0,Radio,0.04*Radio)..(0,Radio,0),1bp+gray);

// Los círculos que marcan el cilindro
real Altura1=0.8, Altura2=0.4;
pen Marcado=1.2+red;
draw(arc((0,0,Altura1),(0,-1,Altura1),(0,1,Altura1),Z),Marcado);
draw(arc((0,0,Altura1),(0,1,Altura1),(0,-1,Altura1),Z),Marcado+Punteado);
draw(arc((0,0,Altura2),(0,-1,Altura2),(0,1,Altura2),Z),Marcado);
draw(arc((0,0,Altura2),(0,1,Altura2),(0,-1,Altura2),Z),Marcado+Punteado);
