//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Mostrar la representación gráfica
// Fecha:    J.12.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 3, Ymin = -2, Ymax = 4, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// Las gráficas
draw((Xmin,Xmin+3)--(1,4));
draw((-3,4)--(Xmax,-Xmax+1));

// La solución
pair R=(-3,0), S=(1,0);
draw(R--S,deepgreen);
dot(R,4bp+deepgreen);
dot(S,4bp+deepgreen);
dot(S,2bp+white);

// Las ecuaciones
label("y=x+3",(1.75,3.5),black+fontsize(6pt));
label("y=1-x",(1.5,0.625),black+fontsize(6pt));
